#include <SPI.h>
#include <Adafruit_GFX.h>
#include <Adafruit_PCD8544.h>

// pin 13 - wyjście zegara (SCLK)
// pin 11 - wyjście szeregowe dane (DIN)
// pin 5 - wybór Dane/Polecenia (Data/Command) — (D/C)
// pin 4 - wybór układu LCD (CS)
// pin 3 - reset LCD (RST)
Adafruit_PCD8544 display = Adafruit_PCD8544(13, 11, 5, 4, 3);

void setup() {
  // tutaj powinien się znaleźć kod inicjalizacji, który uruchamiamy tylko raz:
  Serial.begin(9600);

  display.begin();
  // wykonana inicjalizacja

  display.setContrast(40);

  display.display(); 
  delay(2000);
  display.clearDisplay();   

  display.drawPixel(10, 10, BLACK);
  display.drawPixel(11, 11, BLACK);
   display.drawPixel(12, 12, BLACK);
  display.display();
  delay(2000);
  display.clearDisplay();

  // rysowanie linii
  display.drawLine(3,3,30,30, BLACK);
  display.display();
  delay(2000);
  display.clearDisplay();

  // Wyświetlanie tekstu 
  display.setTextSize(1);
  display.setTextColor(BLACK);
  display.setCursor(0,0);
  display.println("Hello, world!");
  // Wyświetlanie tekstu w negatywie
  display.setTextColor(WHITE, BLACK); 
  display.println(3,141592);
  display.setTextSize(2);
  display.setTextColor(BLACK);
  display.print("This is larger text");
  display.display();
  delay(2000);
  display.clearDisplay();

  // Wyświetlanie tekstu obróconego 
  display.setRotation(1);  // obrót o 90 stopni w lewo, można również użyć wartości 2 i 3, aby zwiększyć obrót.
  display.setTextSize(1);
  display.setTextColor(BLACK);
  display.setCursor(0,0);
  display.println("Hello, world!");
  display.display();
  delay(2000);
  display.clearDisplay();

  // rysowanie okręgu
  display.drawCircle(display.width()/2, display.height()/2, 6, BLACK);
  display.display();
  delay(2000);
  display.clearDisplay();

  // rysowanie okręgu wypełnionego 
  display.fillCircle(display.width()/2, display.height()/2, 6, BLACK);
  display.display();
  delay(2000);
  display.clearDisplay();

  // rysowanie prostokąta
  display.drawRect(15,15,30,15,BLACK);
  display.display();
  delay(2000);
  display.clearDisplay();

  // rysowanie wypełnionego prostokąta
  display.fillRect(15,15,30,15,BLACK);
  display.display();
  delay(2000);
  display.clearDisplay();

  // rysowanie prostokąta z zaokrąglonymi narożnikami
  display.drawRoundRect(15,15,30,15,4,BLACK);
  display.display();
  delay(2000);
  display.clearDisplay();

  // rysowanie wypełnionego prostokąta z zaokrąglonymi narożnikami
  display.fillRoundRect(15,15,30,15,8,BLACK);
  display.display();
  delay(2000);
  display.clearDisplay();
}

void loop() {
  // tutaj powinien się znaleźć główny kod, który uruchamia się w pętli: 

}
